package org.msh.tb.taskscheduling;

import org.jboss.seam.annotations.*;
import org.msh.tb.bd.dashboard.summaryrep.SummaryIndicatorsGenerator;
import org.msh.tb.bd.tbforms.dhis2.schedule.scheduler.DHIS2TB10ExportationScheduler;
import org.msh.tb.bd.tbforms.dhis2.schedule.scheduler.DHIS2TB11ExportationScheduler;
import org.msh.tb.bd.tbforms.dhis2.schedule.scheduler.DHIS2TB12ExportationScheduler;

import java.io.Serializable;
import java.util.Date;

import static org.jboss.seam.ScopeType.APPLICATION;

@Name("taskSchedulerController")
@Scope(APPLICATION)
@AutoCreate
@Startup
public class ScheduleController implements Serializable {
 
    private static final long serialVersionUID = 7609983147081676186L;

    private static String CRON_INTERVAL_1 = "0 0 3 * * ?"; //every day at 3 am
    private static String CRON_INTERVAL_2 = "0 15 3 * * ?"; //every day at 3:15 am
    private static String CRON_INTERVAL_3 = "0 30 3 * * ?"; //every day at 3:30 am
    private static String CRON_INTERVAL_4 = "0 45 3 * * ?"; //every day at 3:45 am
    private static String CRON_INTERVAL_5 = "0 00 4 * * ?"; //every day at 4:00 am

    @In
    TagsUpdaterScheduledTask tagsUpdaterScheduledTask;

    @In
    SummaryIndicatorsGenerator summaryIndicatorsGenerator;

    @In
    DHIS2TB10ExportationScheduler dHIS2TB10ExportationScheduler;

    @In
    DHIS2TB11ExportationScheduler dHIS2TB11ExportationScheduler;

    @In
    DHIS2TB12ExportationScheduler dHIS2TB12ExportationScheduler;
 
    @Create
    public void scheduleTimer() {
        tagsUpdaterScheduledTask.createQuartzTimer(new Date(), CRON_INTERVAL_1);
        summaryIndicatorsGenerator.createQuartzTimer(new Date(), CRON_INTERVAL_2);
        // dHIS2TB10ExportationScheduler.createQuartzTimer(new Date(), CRON_INTERVAL_3);
        // dHIS2TB11ExportationScheduler.createQuartzTimer(new Date(), CRON_INTERVAL_4);
        // dHIS2TB12ExportationScheduler.createQuartzTimer(new Date(), CRON_INTERVAL_5);
    }
}